import {createAsyncAction, createAction, ActionType} from 'typesafe-actions';

import {
    IOrderInfoRequestPayload,
    IOrderInfoSuccessPayload,
    ICreateOrderInfoRequestPayload,
    IRemoveOrderRequestPayload,
    IStartPaymentRequestPayload,
} from './types';

import {EOrderInfo} from './actionTypes';

/* Actions */

/* 1. Order Polling */
export const getOrderInfoActions = createAsyncAction(
    EOrderInfo.START_ORDER_POLLING,
    EOrderInfo.SUCCESS_ORDER_POLLING,
    EOrderInfo.ORDER_POLLING_FAILED,
)<IOrderInfoRequestPayload, IOrderInfoSuccessPayload, undefined>();

export const stopOrderInfoPollingAction = createAction(
    EOrderInfo.STOP_ORDER_POLLING,
)();

export const resetOrderInfoAction = createAction(EOrderInfo.RESET_ORDER_INFO)();

export const orderNeedAuthorizationAction = createAction(
    EOrderInfo.ORDER_POLLING_NEED_AUTHORIZATION,
)();

/* 2. Create order */
export const createOrderActions = createAsyncAction(
    EOrderInfo.CREATE_ORDER,
    EOrderInfo.CREATE_ORDER_SUCCESS,
    EOrderInfo.CREATE_ORDER_FAILED,
)<ICreateOrderInfoRequestPayload, undefined, undefined>();

export const stopCreateOrderActions = createAction(
    EOrderInfo.STOP_CREATE_ORDER,
)();

/* 3. Payment */
export const startOrderPaymentActions = createAsyncAction(
    EOrderInfo.START_PAYMENT_ORDER,
    EOrderInfo.START_PAYMENT_ORDER_SUCCESS,
    EOrderInfo.START_PAYMENT_ORDER_FAILED,
)<IStartPaymentRequestPayload, undefined, undefined>();

export const stopOrderPaymentActions = createAction(
    EOrderInfo.STOP_PAYMENT_ORDER,
)();

/* 3. Remove order */
export const removeOrderActions = createAsyncAction(
    EOrderInfo.REMOVE_ORDER,
    EOrderInfo.REMOVE_ORDER_SUCCESS,
    EOrderInfo.REMOVE_ORDER_FAILED,
)<IRemoveOrderRequestPayload, undefined, undefined>();

/* Action Types */

export type TGetOrderInfoActionType = (
    params: IOrderInfoRequestPayload,
) => void;

export type TCreateOrderRequestActionType = (
    params: ICreateOrderInfoRequestPayload,
) => void;

export type TStartOrderPaymentActions = (
    params: IStartPaymentRequestPayload,
) => void;

export type TRemoveOrderActionType = (
    params: IRemoveOrderRequestPayload,
) => void;

export type TOrderInfoActionTypes =
    | ActionType<typeof getOrderInfoActions>
    | ActionType<typeof startOrderPaymentActions>
    | ActionType<typeof createOrderActions>
    | ActionType<typeof removeOrderActions>
    | ActionType<typeof resetOrderInfoAction>
    | ActionType<typeof orderNeedAuthorizationAction>;
