import {createAsyncAction, ActionType, createAction} from 'typesafe-actions';

import {
    IApplyPromoCodesRequest,
    IAppliedPromoCodesInfo,
} from 'types/hotels/book/IApplyPromoCodes';

import {EPromocodesInfo} from './actionTypes';

/* Actions */

/** TODO: переименовать в estimateDiscount */
export const estimateDiscountActions = createAsyncAction(
    EPromocodesInfo.CHECK_PROMOCODES,
    EPromocodesInfo.CHECK_PROMOCODES_SUCCESS,
    EPromocodesInfo.CHECK_PROMOCODES_FAILED,
)<IApplyPromoCodesRequest, IAppliedPromoCodesInfo, undefined>();

export const resetPromoCodesAction = createAction(
    EPromocodesInfo.RESET_PROMOCODES,
)();

/* Action Types */

export type TEstimateDiscountActionType = (
    params: IApplyPromoCodesRequest,
) => void;

export type TResetPromoCodesActionType = () => void;

export type TPromoCodesInfoActionTypes =
    | ActionType<typeof estimateDiscountActions>
    | ActionType<typeof resetPromoCodesAction>;
