import {createAsyncAction, createAction} from 'typesafe-actions';

import {TCalendarPrices} from 'types/common/calendarPrice/ICalendarPrice';
import {ICalendarPricesRequest} from 'server/api/HotelSearchAPI/types/ICalendarPrices';

import {HOTEL_CALENDAR_PRICES_TYPES} from './actionTypes';

export const startHotelCalendarPricesPoolingAction = createAction(
    HOTEL_CALENDAR_PRICES_TYPES.START_HOTEL_CALENDAR_PRICES_POLLING,
)();

export const getHotelCalendarPricesActions = createAsyncAction(
    HOTEL_CALENDAR_PRICES_TYPES.REQUEST_HOTEL_CALENDAR_PRICES_POLLING,
    HOTEL_CALENDAR_PRICES_TYPES.SUCCESS_HOTEL_CALENDAR_PRICES_POLLING,
    HOTEL_CALENDAR_PRICES_TYPES.FAILED_HOTEL_CALENDAR_PRICES_POLLING,
)<ICalendarPricesRequest, TCalendarPrices, undefined>();

export const stopHotelCalendarPricesAction = createAction(
    HOTEL_CALENDAR_PRICES_TYPES.STOP_HOTEL_CALENDAR_PRICES_POLLING,
)();
