import {ActionType, createReducer} from 'typesafe-actions';

import {TCalendarPrices} from 'types/common/calendarPrice/ICalendarPrice';
import EAsyncStatus from 'types/common/EAsyncStatus';
import {ICalendarPricesRequest} from 'server/api/HotelSearchAPI/types/ICalendarPrices';

import {getHotelCalendarPricesActions} from './actions';

export interface IHotelCalendarPricesReducer {
    status?: EAsyncStatus;
    data?: TCalendarPrices;
    request?: ICalendarPricesRequest;
}

/* Initial State */
const initialState: IHotelCalendarPricesReducer = {};

/* Reducer */
export default createReducer<
    IHotelCalendarPricesReducer,
    ActionType<typeof getHotelCalendarPricesActions>
>(initialState)
    .handleAction(
        getHotelCalendarPricesActions.request,
        (state, {payload}) => ({
            status: EAsyncStatus.LOADING,
            request: payload,
        }),
    )
    .handleAction(
        getHotelCalendarPricesActions.success,
        (state, {payload}) => ({
            ...state,
            status: EAsyncStatus.SUCCESS,
            data: payload,
        }),
    )
    .handleAction(getHotelCalendarPricesActions.failure, () => ({
        status: EAsyncStatus.ERROR,
    }));
