import {createReducer} from 'typesafe-actions';

/* Types */
import {IHotelImages} from './types';

import {
    HotelImagesActionsType,
    getHotelImagesActions,
    resetHotelImagesAction,
} from './actions';

export interface IHotelImagesReducer {
    isLoading: boolean;
    isSuccess: boolean;
    data: IHotelImages;
}

/* Initial State */
const initialState: IHotelImagesReducer = {
    isLoading: false,
    isSuccess: false,
    data: {
        totalImageCount: 0,
        images: [],
    },
};

/* Reducer */
export default createReducer<IHotelImagesReducer, HotelImagesActionsType>(
    initialState,
)
    .handleAction(getHotelImagesActions.request, state => ({
        ...state,
        isLoading: true,
        isSuccess: false,
    }))
    .handleAction(getHotelImagesActions.success, (state, {payload}) => {
        return {
            isLoading: false,
            isSuccess: true,
            data: {
                totalImageCount: payload.totalImageCount,
                images: [...state.data.images, ...payload.images],
            },
        };
    })
    .handleAction(resetHotelImagesAction, () => initialState);
