import {OperatorIdType} from 'types/hotels/offer/IHotelsOperator';
import {IHotelOffer} from 'types/hotels/offer/IHotelOffer';
import {IHotelRoom} from 'types/hotels/offer/IHotelRoom';

export * from 'server/api/HotelSearchAPI/types/IHotelInfo';
export * from 'server/api/HotelSearchAPI/types/IHotelBreadcrumbs';
export * from 'server/api/HotelSearchAPI/types/ISimilarHotels';
export * from 'server/api/HotelSearchAPI/types/IOffersInfo';
export * from 'server/api/HotelSearchAPI/types/IHotelReviews';

import IPrice from 'utilities/currency/PriceInterface';

export * from 'server/api/HotelSearchAPI/types/IOffersInfo';

/* Filters */
export enum FilterType {
    MEAL = 'meal',
    REFUND = 'refund',
}

export type FilterKeyType = keyof typeof FilterType;

export type HotelOffersFiltersType = {
    [filterId in FilterType]: boolean;
};

/* Room entities */
export interface IRoomOfferOperator {
    operatorId: OperatorIdType;
    landingUrl: string;
    price: IPrice;
}

export type HotelRoomOfferType = Omit<
    IHotelOffer,
    'price' | 'operatorId' | 'landingUrl'
> & {
    operators: IRoomOfferOperator[];
};

export interface IHotelRoomWithOffers extends IHotelRoom {
    offers: HotelRoomOfferType[];
}

export interface IHotelBoyMetaRoomWithOffers extends IHotelRoom {
    offers: IHotelOffer[];
}
