import {createReducer} from 'typesafe-actions';

import {
    addHotelReviewActions,
    AddReviewRequestActionsType,
    resetAddHotelReviewAction,
} from './actions';

export interface IAddReviewReducer {
    isSubmitting: boolean;
    isSuccess: boolean;
    hasError: boolean;
}

/* Initial State */
const initialState: IAddReviewReducer = {
    isSubmitting: false,
    isSuccess: false,
    hasError: false,
};

/* Reducer */
export default createReducer<IAddReviewReducer, AddReviewRequestActionsType>(
    initialState,
)
    .handleAction(addHotelReviewActions.request, state => ({
        ...state,
        isSubmitting: true,
        isSuccess: false,
        hasError: false,
    }))
    .handleAction(addHotelReviewActions.success, state => {
        return {
            ...state,
            isSubmitting: false,
            isSuccess: true,
            hasError: false,
        };
    })
    .handleAction(addHotelReviewActions.failure, state => {
        return {
            ...state,
            isSubmitting: false,
            isSuccess: false,
            hasError: true,
        };
    })
    .handleAction(resetAddHotelReviewAction, () => {
        return {
            ...initialState,
        };
    });
