import {createAsyncAction, ActionType} from 'typesafe-actions';

import {
    IDeleteHotelReviewRequest,
    IDeleteHotelReviewResponse,
} from 'server/api/HotelSearchAPI/types/IDeleteHotelReview';

import {HOTEL_DELETE_REVIEW_ACTION_TYPES} from './actionTypes';

export const deleteHotelReviewActions = createAsyncAction(
    HOTEL_DELETE_REVIEW_ACTION_TYPES.DELETE_HOTEL_REVIEW_REQUEST,
    HOTEL_DELETE_REVIEW_ACTION_TYPES.DELETE_HOTEL_REVIEW_SUCCESS,
    HOTEL_DELETE_REVIEW_ACTION_TYPES.DELETE_HOTEL_REVIEW_FAIL,
)<IDeleteHotelReviewRequest, IDeleteHotelReviewResponse, undefined>();

export type DeleteReviewRequestActionsType = ActionType<
    typeof deleteHotelReviewActions
>;
