import {createAsyncAction, ActionType, createAction} from 'typesafe-actions';

import {
    IEditHotelReviewRequest,
    IEditHotelReviewResponse,
} from 'server/api/HotelSearchAPI/types/IEditHotelReview';

import {HOTEL_EDIT_REVIEW_ACTION_TYPES} from './actionTypes';

export const editHotelReviewActions = createAsyncAction(
    HOTEL_EDIT_REVIEW_ACTION_TYPES.EDIT_HOTEL_REVIEW_REQUEST,
    HOTEL_EDIT_REVIEW_ACTION_TYPES.EDIT_HOTEL_REVIEW_SUCCESS,
    HOTEL_EDIT_REVIEW_ACTION_TYPES.EDIT_HOTEL_REVIEW_FAIL,
)<IEditHotelReviewRequest, IEditHotelReviewResponse, undefined>();

export const resetEditHotelReviewAction = createAction(
    HOTEL_EDIT_REVIEW_ACTION_TYPES.EDIT_HOTEL_REVIEW_RESET,
)();

export type EditReviewRequestActionsType = ActionType<
    typeof editHotelReviewActions | typeof resetEditHotelReviewAction
>;
