import {createAsyncAction, createAction, ActionType} from 'typesafe-actions';

import {IHotelReviewReactionRequestParams} from 'server/api/HotelSearchAPI/types/IHotelReviewReaction';
import {
    IHotelReviewReaction,
    IHotelReviewsInfo,
    IHotelReviewsQuantitativeAndFilterParams,
    IHotelReviewReactionPayload,
} from './types';
import {ETextReviewRankingType} from 'server/api/HotelSearchAPI/types/ETextReviewRankingType';

import {HOTEL_REVIEWS_ACTION_TYPES} from './actionTypes';

/* ACTIONS */

/* 1. FetchReviews */
/* 1.1 Получение отзывов отеля */
export const getHotelReviewsActions = createAsyncAction(
    HOTEL_REVIEWS_ACTION_TYPES.START_HOTEL_REVIEWS_REQUEST,
    HOTEL_REVIEWS_ACTION_TYPES.SUCCESS_HOTEL_REVIEWS_REQUEST,
    HOTEL_REVIEWS_ACTION_TYPES.FAILED_HOTEL_REVIEWS_REQUEST,
)<IHotelReviewsQuantitativeAndFilterParams, IHotelReviewsInfo, undefined>();
/* 1.2 Полный сброс всей информации об отзывах отеля */
export const resetHotelReviewsAction = createAction(
    HOTEL_REVIEWS_ACTION_TYPES.RESET_HOTEL_REVIEWS,
)();
/* 1.3 Сброс только списка отзывов об отеле */
export const resetHotelReviewsListAction = createAction(
    HOTEL_REVIEWS_ACTION_TYPES.RESET_HOTEL_REVIEWS_LIST,
)();

/* 2. KeyPhrases */
/* 2.1 Установка ключевого слова */
export const setActiveKeywordAction = createAction(
    HOTEL_REVIEWS_ACTION_TYPES.SET_ACTIVE_KEYWORD,
)<string | undefined>();
/* 2.2 Установка ключевого слова и запрос по нему */
export const filterHotelReviewsActions = createAction(
    HOTEL_REVIEWS_ACTION_TYPES.FILTER_HOTEL_REVIEWS_REQUEST,
)<IHotelReviewsQuantitativeAndFilterParams>();

/* 3. ReviewReaction */
/* 3.1 Оптимистичная установка реакции пользователя на комментарий на главном табе и на табе с отзывами */
export const setHotelReviewInfoReactionAction = createAction(
    HOTEL_REVIEWS_ACTION_TYPES.SET_HOTEL_REVIEW_INFO_REACTION,
)<IHotelReviewReaction>();
/* 3.2 Оптимистичная установка реакции пользователя на комментарий на табе с отзывами */
export const setHotelReviewReactionAction = createAction(
    HOTEL_REVIEWS_ACTION_TYPES.SET_HOTEL_REVIEW_REACTION,
)<IHotelReviewReaction>();
/* 3.3 Запрос установки реакции пользователя на комметарий */
export const setHotelReviewReactionRequestActions = createAsyncAction(
    HOTEL_REVIEWS_ACTION_TYPES.START_HOTEL_REVIEW_REACTION_REQUEST,
    HOTEL_REVIEWS_ACTION_TYPES.SUCCESS_HOTEL_REVIEW_REACTION_REQUEST,
    HOTEL_REVIEWS_ACTION_TYPES.FAILED_HOTEL_REVIEW_REACTION_REQUEST,
)<
    IHotelReviewReactionPayload,
    IHotelReviewReactionRequestParams,
    IHotelReviewReactionRequestParams
>();

/* 4. Сортировка*/
/* 4.1 Сортировка списка отзывов об отеле */
export const sortingHotelReviewsAction = createAction(
    HOTEL_REVIEWS_ACTION_TYPES.SORTING_HOTEL_REVIEWS_LIST,
)<IHotelReviewsQuantitativeAndFilterParams>();
/* 4.2 Установка текущей сортировки списка отзывов об отеле */
export const setHotelReviewsSortingOptionAction = createAction(
    HOTEL_REVIEWS_ACTION_TYPES.SET_HOTEL_REVIEW_SORTING_OPTION,
)<ETextReviewRankingType>();

/* TYPES */

/* 1. FetchReviews */
/* 1.1 Получение отзывов отеля */
export type HotelReviewsRequestActionsType = ActionType<
    typeof getHotelReviewsActions
>;
export type GetHotelReviewsActionType = (
    params: IHotelReviewsQuantitativeAndFilterParams,
) => void;
/* 1.2 Полный сброс всей информации об отзывах отеля */
export type HotelReviewsResetActionType = ActionType<
    typeof resetHotelReviewsAction
>;
/* 1.3 Сброс только списка отзывов об отеле */
export type HotelReviewsListResetActionType = ActionType<
    typeof resetHotelReviewsListAction
>;

/* 2. KeyPhrases */
/* 2.1 Установка ключевого слова */
export type HotelReviewsSetKeyword = ActionType<typeof setActiveKeywordAction>;
/* 2.2 Установка ключевого слова и запрос по нему */
export type FilterHotelReviewsActionType = (
    params: IHotelReviewsQuantitativeAndFilterParams,
) => void;

/* 3. ReviewReaction */
/* 3.1 Оптимистичная установка реакции пользователя на комментарий на главном табе */
export type HotelReviewInfoReactionActionsType = ActionType<
    typeof setHotelReviewInfoReactionAction
>;
export type SetHotelReviewInfoReactionActionType = (
    params: IHotelReviewReaction,
) => void;
/* 3.2 Оптимистичная установка реакции пользователя на комментарий на табе с отзывами */
export type HotelReviewReactionActionsType = ActionType<
    typeof setHotelReviewReactionAction
>;
/* 3.3 Запрос установки реакции пользователя на комметарий */
export type HotelReviewReactionRequestActionsType = ActionType<
    typeof setHotelReviewReactionRequestActions
>;
export type SetHotelReviewReactionRequestActionType = (
    params: IHotelReviewReactionPayload,
) => void;

/* 4. Сортировка*/
/* 4.1 Сортировка списка отзывов об отеле */
export type SortingHotelReviewsActionType = (
    params: IHotelReviewsQuantitativeAndFilterParams,
) => void;
/* 4.2 Установка текущей сортировки списка отзывов об отеле */
export type SetHotelReviewsSortingOptionActionType = ActionType<
    typeof setHotelReviewsSortingOptionAction
>;

/* Total types */
export type HotelReviewsActionsType =
    | HotelReviewsRequestActionsType
    | HotelReviewsResetActionType
    | HotelReviewsListResetActionType
    | HotelReviewsSetKeyword
    | HotelReviewReactionRequestActionsType
    | HotelReviewReactionActionsType
    | HotelReviewInfoReactionActionsType
    | SetHotelReviewsSortingOptionActionType;
