export type ReactionCountsType = {
    totalLikeCount: number;
    totalDislikeCount: number;
};

function getTotalReviewReactionCounts(
    counts: ReactionCountsType,
    beforeReaction: string,
    userReaction: string,
): ReactionCountsType {
    const {totalLikeCount, totalDislikeCount} = counts;

    switch (beforeReaction) {
        case 'LIKE': {
            if (userReaction === 'DISLIKE') {
                return {
                    totalLikeCount: totalLikeCount - 1,
                    totalDislikeCount: totalDislikeCount + 1,
                };
            } else if (userReaction === 'NONE') {
                return {
                    totalLikeCount: totalLikeCount - 1,
                    totalDislikeCount: totalDislikeCount,
                };
            }
            break;
        }
        case 'DISLIKE': {
            if (userReaction === 'LIKE') {
                return {
                    totalLikeCount: totalLikeCount + 1,
                    totalDislikeCount: totalDislikeCount - 1,
                };
            } else if (userReaction === 'NONE') {
                return {
                    totalLikeCount: totalLikeCount,
                    totalDislikeCount: totalDislikeCount - 1,
                };
            }
            break;
        }
        case 'NONE': {
            if (userReaction === 'LIKE') {
                return {
                    totalLikeCount: totalLikeCount + 1,
                    totalDislikeCount: totalDislikeCount,
                };
            } else if (userReaction === 'DISLIKE') {
                return {
                    totalLikeCount: totalLikeCount,
                    totalDislikeCount: totalDislikeCount + 1,
                };
            }
        }
    }

    return {
        totalLikeCount: totalLikeCount,
        totalDislikeCount: totalDislikeCount,
    };
}

export default getTotalReviewReactionCounts;
