import {createAsyncAction, ActionType} from 'typesafe-actions';

import {ILegacyHotelInfoRequestParams, ILegacyHotelInfoResponse} from './types';

import {LEGACY_HOTEL_INFO_TYPES} from './actionTypes';

export const fetchLegacyHotelInfoActions = createAsyncAction(
    LEGACY_HOTEL_INFO_TYPES.START,
    LEGACY_HOTEL_INFO_TYPES.SUCCESS,
    LEGACY_HOTEL_INFO_TYPES.FAILED,
)<ILegacyHotelInfoRequestParams, ILegacyHotelInfoResponse, undefined>();

export type StartFetchLegacyHotelInfoType = (
    payload: ILegacyHotelInfoRequestParams,
) => void;

/* Action Types */
export type FetchLegacyHotelInfoActionsType = ActionType<
    typeof fetchLegacyHotelInfoActions
>;
