import {createReducer} from 'typesafe-actions';

import {ILegacyHotelInfo} from './types';

import {
    FetchLegacyHotelInfoActionsType,
    fetchLegacyHotelInfoActions,
} from './actions';

/* Reducer Types */

export interface ILegacyHotelInfoReducer {
    isLoading: boolean;
    isError: boolean;
    data?: ILegacyHotelInfo;
}

/* Initial State */

const initialState: ILegacyHotelInfoReducer = {
    isLoading: true,
    isError: false,
};

/* Reducer */

const legacyHotelInfoReducer = createReducer<
    ILegacyHotelInfoReducer,
    FetchLegacyHotelInfoActionsType
>(initialState)
    .handleAction(
        fetchLegacyHotelInfoActions.request,
        (state): ILegacyHotelInfoReducer => ({
            ...state,
            isLoading: true,
        }),
    )
    .handleAction(
        fetchLegacyHotelInfoActions.success,
        (state, {payload}): ILegacyHotelInfoReducer => ({
            isLoading: false,
            isError: false,
            data: payload,
        }),
    )
    .handleAction(
        fetchLegacyHotelInfoActions.failure,
        (): ILegacyHotelInfoReducer => ({
            isLoading: false,
            isError: true,
            data: undefined,
        }),
    );

export default legacyHotelInfoReducer;
