import {createAsyncAction, ActionType} from 'typesafe-actions';

import IGetHotelsSuggestsResponse from 'server/api/PersonalizationApi/types/IGetHotelsSuggestsResponse';
import IGetHotelsSuggestsRequestParams from 'server/api/PersonalizationApi/types/IGetHotelsSuggestsRequestParams';

import {HOTELS_PERSONALIZATION_ACTION_TYPES} from './actionTypes';

export const getHotelsSuggestsActions = createAsyncAction(
    HOTELS_PERSONALIZATION_ACTION_TYPES.START_GET_PERSONALIZATION_SUGGESTS_REQUEST,
    HOTELS_PERSONALIZATION_ACTION_TYPES.SUCCESS_GET_PERSONALIZATION_SUGGESTS_REQUEST,
    HOTELS_PERSONALIZATION_ACTION_TYPES.FAILED_GET_PERSONALIZATION_SUGGESTS_REQUEST,
)<IGetHotelsSuggestsRequestParams, IGetHotelsSuggestsResponse, undefined>();

export type GetHotelsSuggestsActionsType = ActionType<
    typeof getHotelsSuggestsActions
>;

export type HotelsPersonalizationActionsTypes = GetHotelsSuggestsActionsType;
