import {createReducer} from 'typesafe-actions';

import IPersonalizedHotelItem from 'server/api/PersonalizationApi/types/IPersonalizedHotelItem';
import EAsyncStatus from 'types/common/EAsyncStatus';

import {
    HotelsPersonalizationActionsTypes,
    getHotelsSuggestsActions,
} from './actions';

export interface ISuggestInfo {
    status: EAsyncStatus | null;
    items: IPersonalizedHotelItem[];
}

export interface IHotelPersonalization {
    suggests: ISuggestInfo;
}

const initialState: IHotelPersonalization = {
    suggests: {
        status: null,
        items: [],
    },
};

/* Reducer */
export default createReducer<
    IHotelPersonalization,
    HotelsPersonalizationActionsTypes
>(initialState)
    .handleAction(getHotelsSuggestsActions.request, () => ({
        ...initialState,
        suggests: {
            ...initialState.suggests,
            status: EAsyncStatus.LOADING,
        },
    }))
    .handleAction(
        getHotelsSuggestsActions.success,
        (state, {payload}): IHotelPersonalization => ({
            ...state,
            suggests: {
                status: EAsyncStatus.SUCCESS,
                items: payload.items,
            },
        }),
    )
    .handleAction(
        getHotelsSuggestsActions.failure,
        (): IHotelPersonalization => ({
            ...initialState,
            suggests: {
                ...initialState.suggests,
                status: EAsyncStatus.ERROR,
            },
        }),
    );
