import {createReducer} from 'typesafe-actions';

import {IHotelsPreviousSearch} from 'types/hotels/previousSearches/IPreviousSearch';

import {
    setPreviousSearchesAction,
    THotelsPreviousSearchesActions,
} from 'reducers/hotels/previousSearches/actions';

export interface IHotelsPreviousSearchesStore {
    items: IHotelsPreviousSearch[] | null;
}

const INITIAL_STATE: IHotelsPreviousSearchesStore = {
    items: null,
};

export default createReducer<
    IHotelsPreviousSearchesStore,
    THotelsPreviousSearchesActions
>(INITIAL_STATE).handleAction(
    setPreviousSearchesAction,
    (state, {payload}) => ({
        ...state,
        items: payload,
    }),
);
