import {batchActions} from 'redux-batched-actions';

import {IHotelsPreviousSearch} from 'types/hotels/previousSearches/IPreviousSearch';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {
    setHotelsSearchFormAdultsFieldAction,
    setHotelsSearchFormChildrenAgesFieldAction,
    setHotelsSearchFormEndDateFieldAction,
    setHotelsSearchFormStartDateFieldAction,
    setHotelsSearchFormToFieldAction,
} from 'reducers/hotels/searchForm/actions';

import {ESuggestSource} from 'components/SearchSuggest/SearchSuggest';

export default function fillSearchFormByPreviousSearchThunkAction(
    previousSearch: IHotelsPreviousSearch,
): CustomThunkAction<void> {
    return (dispatch): void => {
        dispatch(
            batchActions([
                setHotelsSearchFormToFieldAction({
                    inputValue: previousSearch.to.name,
                    source: ESuggestSource.PRESETS,
                    selectedValue: previousSearch.to,
                }),
                setHotelsSearchFormStartDateFieldAction(
                    previousSearch.startDate,
                ),
                setHotelsSearchFormEndDateFieldAction(previousSearch.endDate),
                setHotelsSearchFormAdultsFieldAction(previousSearch.adults),
                setHotelsSearchFormChildrenAgesFieldAction(
                    previousSearch.childrenAges,
                ),
            ]),
        );
    };
}
