import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {setPreviousSearchesAction} from 'reducers/hotels/previousSearches/actions';
import restorePreviousSearches from 'reducers/hotels/previousSearches/thunk/utilities/restorePreviousSearches';

export default function restorePreviousSearchesThunkAction(): CustomThunkAction<void> {
    return (dispatch, getState): void => {
        const {
            hotels: {
                previousSearches: {items},
            },
        } = getState();

        if (items) {
            return;
        }

        dispatch(setPreviousSearchesAction(restorePreviousSearches()));
    };
}
