import {combineReducers} from 'redux';

import {ELoadableReducer} from 'types/common/ELoadableReducer';

import searchForm from 'reducers/hotels/searchForm/reducer';
import loadableReducer from 'reducers/utils/loadableReducers/loadableReducer';
import {IHotelsStore} from 'reducers/hotels/IHotelsStore';

const hotelsRootReducer = combineReducers<IHotelsStore>({
    searchForm,
    searchSuggests: loadableReducer(ELoadableReducer.HOTELS_SEARCH_SUGGESTS),
    legacyHotelPage: loadableReducer(ELoadableReducer.HOTELS_LEGACY_HOTEL_PAGE),
    bookAndPay: loadableReducer(ELoadableReducer.HOTELS_BOOK_AND_PAY),
    searchHotelsPage: loadableReducer(ELoadableReducer.HOTELS_SEARCH_PAGE),
    hotelPage: loadableReducer(ELoadableReducer.HOTELS_HOTEL_PAGE),
    searchInformation: loadableReducer(
        ELoadableReducer.HOTELS_SEARCH_INFORMATION,
    ),
    geoRegionPage: loadableReducer(ELoadableReducer.HOTELS_GEO_REGION_PAGE),
    welcomePromocode: loadableReducer(
        ELoadableReducer.HOTELS_WELCOME_PROMOCODE,
    ),
    previousSearches: loadableReducer(
        ELoadableReducer.HOTELS_PREVIOUS_SEARCHES,
    ),
    personalization: loadableReducer(ELoadableReducer.HOTELS_PERSONALIZATION),
});

export default hotelsRootReducer;
