import {createReducer} from 'typesafe-actions';

import {DEFAULT_ADULTS_COUNT} from 'constants/hotels';

import {ISearchInformation} from './types';

import {
    SearchInformationActionsTypes,
    updateSearchInformation,
    clearSearchInformation,
} from './actions';

const initialState: ISearchInformation = {
    childrenAges: [],
    adults: DEFAULT_ADULTS_COUNT,
    checkinDate: '',
    checkoutDate: '',
    geoObject: {
        name: '',
    },
    hotel: {
        name: '',
        permalink: '',
        hotelSlug: '',
    },
    activeSuggest: null,
};

/* Reducer */
export default createReducer<ISearchInformation, SearchInformationActionsTypes>(
    initialState,
)
    .handleAction(clearSearchInformation, () => initialState)
    .handleAction(
        updateSearchInformation,
        (state, {payload}): ISearchInformation => ({
            ...state,
            ...payload,
        }),
    );
