import {ActionType, createAction, createAsyncAction} from 'typesafe-actions';

/* Types */
import {
    IChangeFilterGroupPayloadWithTarget,
    IChangeFiltersTargetType,
    IChangePriceFilterPayloadWithTarget,
    ICurrentGeoIdFilterPayloadWithTarget,
} from 'types/hotels/search/IFiltersInfo';
import {ISearchHotelsInfo} from 'server/api/HotelsSearchAPI/types/ISearchHotels';
import {ICountHotelsResponse} from './types';
import {
    IResetFilterAction,
    IResetFilterInfo,
} from 'server/api/HotelsSearchAPI/types/IResetFilterInfo';

import {FILTERS_ACTION_TYPES} from './actionTypes';

export interface ICollapsedFilterInfo {
    id: string;
    wasCollapsed: boolean;
}

/* Actions */

export const fillFilters = createAction(
    FILTERS_ACTION_TYPES.FILL_FILTERS,
)<ISearchHotelsInfo>();

export const fillResetActions = createAction(
    FILTERS_ACTION_TYPES.FILL_FILTERS_RESET_ACTIONS,
)<IResetFilterInfo | null>();

export const resetFilterAction = createAction(
    FILTERS_ACTION_TYPES.RESET_FILTER_ACTION,
)<IResetFilterAction>();

export const changeFilterGroup = createAction(
    FILTERS_ACTION_TYPES.CHANGE_FILTERS_GROUP,
)<IChangeFilterGroupPayloadWithTarget>();

export const changePriceFilter = createAction(
    FILTERS_ACTION_TYPES.CHANGE_PRICE_FILTER,
)<IChangePriceFilterPayloadWithTarget>();

export const resetPriceFilter = createAction(
    FILTERS_ACTION_TYPES.RESET_PRICE_FILTER,
)<IChangeFiltersTargetType>();

export const changeCurrentGeoIdFilter = createAction(
    FILTERS_ACTION_TYPES.CHANGE_CURRENT_GEOID_FILTER,
)<ICurrentGeoIdFilterPayloadWithTarget>();

export const resetFilters = createAction(FILTERS_ACTION_TYPES.RESET_FILTERS)();

export const applyFilters = createAction(FILTERS_ACTION_TYPES.APPLY_FILTERS)();

export const revertFilters = createAction(
    FILTERS_ACTION_TYPES.REVERT_FILTERS,
)();

export const resetFiltersToInitial = createAction(
    FILTERS_ACTION_TYPES.RESET_FILTERS_TO_INITIAL,
)();

export const updateCountFiltersActions = createAsyncAction(
    FILTERS_ACTION_TYPES.START_UPDATE_COUNT_FILTERS,
    FILTERS_ACTION_TYPES.SUCCESS_UPDATE_COUNT_FILTERS,
    FILTERS_ACTION_TYPES.FAILED_UPDATE_COUNT_FILTERS,
)<undefined, ICountHotelsResponse, undefined>();

export const toggleFilterCollapse = createAction(
    FILTERS_ACTION_TYPES.TOGGLE_FILTER_COLLAPSE,
)<ICollapsedFilterInfo>();

/* Action Types */

export type TUpdateCountFiltersActionsType = ActionType<
    typeof updateCountFiltersActions
>;
export type UpdateCountFiltersActionType = () => void;
export type ChangeFilterGroupType = typeof changeFilterGroup;
export type FillFiltersActionType = typeof fillFilters;
export type FillResetFiltersActionType = typeof fillResetActions;
export type ResetFilterActionType = typeof resetFilterAction;
export type ResetPriceFilterType = typeof resetPriceFilter;
export type ChangePriceFilterType = typeof changePriceFilter;
export type ResetFiltersActionType = typeof resetFilters;
export type ApplyFiltersActionType = typeof applyFilters;
export type RevertFiltersActionType = typeof revertFilters;
export type ResetFiltersToInitialActionType = typeof resetFiltersToInitial;
export type ToggleFilterCollapseActionType = typeof toggleFilterCollapse;

export type FiltersActionsType =
    | TUpdateCountFiltersActionsType
    | ActionType<
          | FillFiltersActionType
          | FillResetFiltersActionType
          | ResetFilterActionType
          | ResetPriceFilterType
          | ChangeFilterGroupType
          | ResetFiltersActionType
          | ChangePriceFilterType
          | ApplyFiltersActionType
          | RevertFiltersActionType
          | ResetFiltersToInitialActionType
          | ToggleFilterCollapseActionType
          | typeof changeCurrentGeoIdFilter
      >;
