import {CustomThunkAction} from 'reducers/trains/customDispatch';

import collapsedFiltersSaver from 'projects/hotels/utilities/filters/collapsedFiltersSaver';

import {
    ICollapsedFilterInfo,
    resetFilters,
    applyFilters,
    toggleFilterCollapse,
} from './actions';

export const resetFiltersAndSearch =
    (): CustomThunkAction<void> =>
    (dispatch): void => {
        dispatch(resetFilters());
        dispatch(applyFilters());
    };

export const toggleFilterCollapseAndSave =
    (collapsedFilterInfo: ICollapsedFilterInfo): CustomThunkAction<void> =>
    (dispatch, getState): void => {
        dispatch(toggleFilterCollapse(collapsedFilterInfo));

        collapsedFiltersSaver.saveToStorage(
            getState().hotels.searchHotelsPage.filters.collapsedFilters,
        );
    };
