import {createAction} from 'typesafe-actions';

import {NavigationTokenType} from 'types/hotels/search/INavigationTokens';
import {ISearchHotelsInfo} from 'server/api/HotelsSearchAPI/types/ISearchHotels';

import {HOTEL_LIST_ACTION_TYPES} from './actionTypes';

type TFillHotelList = {
    pollingResponse: ISearchHotelsInfo;
    pageHotelCount: number;
    withInfiniteScroll?: boolean;
};

export const setNavigationToken = createAction(
    HOTEL_LIST_ACTION_TYPES.SET_NAVIGATION_TOKEN,
)<NavigationTokenType | undefined>();
export const fillHotelList = createAction(
    HOTEL_LIST_ACTION_TYPES.FILL_HOTEL_LIST,
)<TFillHotelList>();
export const resetHotelList = createAction(
    HOTEL_LIST_ACTION_TYPES.RESET_HOTEL_LIST,
)();
export const resetHotelListToInitial = createAction(
    HOTEL_LIST_ACTION_TYPES.RESET_HOTEL_LIST_TO_INITIAL,
)();
