import {createAsyncAction, createAction, ActionType} from 'typesafe-actions';

import {ISearchHotelsInfo} from './types';
import {PermalinkType} from 'types/hotels/hotel/IHotel';
import {EStartSearchReason} from 'types/hotels/search/ISearchReason';
import {IRemoveFavoriteHotelByPermalinkRequestParams} from 'server/api/HotelsFavoritesAPI/types/IRemoveFavoriteHotelsRequestParams';
import IAddFavoriteHotelRequestParams from 'server/api/HotelsFavoritesAPI/types/IAddFavoriteHotelRequestParams';

import {SEARCH_HOTELS_ACTION_TYPES} from './actionTypes';

export interface IStartSearchActionPayload {
    startSearchReason: EStartSearchReason;
}

export interface ISyncSearchParamsWithLoactionActionPayload {
    preventScroll: boolean;
}

/* Start Polling Epoch */
export const searchHotelsActions = createAsyncAction(
    SEARCH_HOTELS_ACTION_TYPES.START_SEARCH,
    SEARCH_HOTELS_ACTION_TYPES.SUCCESS_SEARCH,
    SEARCH_HOTELS_ACTION_TYPES.FAILED_SEARCH,
)<IStartSearchActionPayload, ISearchHotelsInfo, undefined>();

/* Stop Polling Epoch */
export const stopSearchHotels = createAction(
    SEARCH_HOTELS_ACTION_TYPES.STOP_SEARCH,
)<undefined>();

/* Clear result */
export const clearSearchResult = createAction(
    SEARCH_HOTELS_ACTION_TYPES.CLEAR_SEARCH_RESULT,
)<undefined>();

export const clearSearchBeforeNewSearch = createAction(
    SEARCH_HOTELS_ACTION_TYPES.CREAR_SEARCH_RESULT_BEFORE_NEW_SEARCH,
)<undefined>();

export const clearLastSearchTimestampAction = createAction(
    SEARCH_HOTELS_ACTION_TYPES.CLEAR_LAST_SEARCH_TIMESTAMP,
)<undefined>();

/* Clear hotels */
export const clearHotels = createAction(
    SEARCH_HOTELS_ACTION_TYPES.CLEAR_HOTELS,
)<undefined>();

/* Clear not finished hotels */
export const clearNotFinishedHotels = createAction(
    SEARCH_HOTELS_ACTION_TYPES.CLEAR_NOT_FINISHED_HOTELS,
)<undefined>();

/* Sync searchParams with location */
export const syncSearchParamsWithLocation = createAction(
    SEARCH_HOTELS_ACTION_TYPES.SYNC_SEARCH_PARAMS_WITH_LOCATION,
)<ISyncSearchParamsWithLoactionActionPayload>();

/* Action Types */
export type SearchPollingActionsType = ActionType<typeof searchHotelsActions>;
export type StartSearchHotelsType = (
    searchParams: IStartSearchActionPayload,
) => void;
export type StopSearchType = typeof stopSearchHotels;
export type ClearSearchResultType = typeof clearSearchResult;
export type ClearSearchBeforeNewSearch = typeof clearSearchBeforeNewSearch;
export type ClearLastSearchTimestamp = typeof clearLastSearchTimestampAction;
export type ClearHotelsType = typeof clearHotels;
export type ClearNotFinishedHotelsType = typeof clearNotFinishedHotels;

/* Favorites */
export const changeHotelsIsFavoriteOnSearchActions = createAsyncAction(
    SEARCH_HOTELS_ACTION_TYPES.START_CHANGE_HOTELS_IS_FAVORITE_REACTION_REQUEST,
    SEARCH_HOTELS_ACTION_TYPES.SUCCESS_CHANGE_HOTELS_IS_FAVORITE_REACTION_REQUEST,
    SEARCH_HOTELS_ACTION_TYPES.FAILED_CHANGE_HOTELS_IS_FAVORITE_REACTION_REQUEST,
)<
    | IAddFavoriteHotelRequestParams
    | IRemoveFavoriteHotelByPermalinkRequestParams,
    PermalinkType,
    undefined
>();
export type ChangeHotelsIsFavoriteOnSearchType =
    typeof changeHotelsIsFavoriteOnSearchActions.request;

export type ChangeHotelsIsFavoriteOnSearchActionsType = ActionType<
    typeof changeHotelsIsFavoriteOnSearchActions
>;

export const changeIsOpenForNoMoreFavoritesModalAction = createAction(
    SEARCH_HOTELS_ACTION_TYPES.CHANGE_IS_OPEN_FOR_NO_MORE_FAVORITES_MODAL,
)<boolean>();

export type ChangeIsOpenForNoMoreFavoritesModalActionType =
    typeof changeIsOpenForNoMoreFavoritesModalAction;

export type SearchHotelsActionsType =
    | SearchPollingActionsType
    | ChangeHotelsIsFavoriteOnSearchActionsType
    | ActionType<
          | StopSearchType
          | ClearSearchResultType
          | ClearNotFinishedHotelsType
          | ClearHotelsType
          | ClearSearchBeforeNewSearch
          | ClearLastSearchTimestamp
          | ChangeIsOpenForNoMoreFavoritesModalActionType
      >;
