import React from 'react';

import IAddFavoriteHotelRequestParams from 'server/api/HotelsFavoritesAPI/types/IAddFavoriteHotelRequestParams';
import {EAddToFavoritesError} from 'server/api/HotelsFavoritesAPI/types/EAddToFavoritesError';
import {IRemoveFavoriteHotelByPermalinkRequestParams} from 'server/api/HotelsFavoritesAPI/types/IRemoveFavoriteHotelsRequestParams';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {setSnackbarInfo} from 'reducers/common/snackbar/actions';

import {getAttributionParams} from 'projects/hotels/utilities/getAttributionParams/getAttributionParams';

import {hotelsFavoritesService} from 'serviceProvider';

import {
    changeIsOpenForNoMoreFavoritesModalAction,
    changeHotelsIsFavoriteOnSearchActions,
} from './actions';

export interface IAddFavoriteHotelParams {
    requestParams: IAddFavoriteHotelRequestParams;
    message?: React.ReactElement | string;
}

export const addFavoriteHotel = ({
    requestParams: {permalink},
    message,
}: IAddFavoriteHotelParams): CustomThunkAction<void> => {
    return async dispatch => {
        try {
            const fillRequestParams: IAddFavoriteHotelRequestParams = {
                permalink,
                ...getAttributionParams(),
            };

            const result = await hotelsFavoritesService
                .provider()
                .addFavoriteHotel(fillRequestParams);

            if (
                'error' in result &&
                result.error &&
                result.error === EAddToFavoritesError.HOTEL_LIMIT_EXCEEDED
            ) {
                dispatch(changeIsOpenForNoMoreFavoritesModalAction(true));

                return;
            } else if ('error' in result && !result.error) {
                dispatch(
                    changeHotelsIsFavoriteOnSearchActions.success(permalink),
                );

                if (message) {
                    dispatch(
                        setSnackbarInfo({
                            lastAction: `${permalink}-add`,
                            hasCancellation: false,
                            message,
                            page: 'search',
                        }),
                    );
                }
            }
        } catch (error) {
            dispatch(changeHotelsIsFavoriteOnSearchActions.failure());
        }
    };
};

export const removeFavoriteHotel = ({
    permalink,
}: IRemoveFavoriteHotelByPermalinkRequestParams): CustomThunkAction<void> => {
    return async dispatch => {
        try {
            const requestParams = {
                permalink,
                ...getAttributionParams(),
            };

            await hotelsFavoritesService
                .provider()
                .removeFavoriteHotels(requestParams);

            dispatch(changeHotelsIsFavoriteOnSearchActions.success(permalink));
        } catch (error) {
            dispatch(changeHotelsIsFavoriteOnSearchActions.failure());
        }
    };
};
