import {createReducer} from 'typesafe-actions';

/* Types */
import {ISortInfo} from 'types/hotels/search/ISortInfo';

import {
    fillSortInfo,
    resetSortToInitial,
    setActiveSort,
    TSortActions,
} from './actions';

export interface ISortHotelsReducer {
    needSyncSortWithServer: boolean;
    sortInfo?: ISortInfo;
    sortOrigin?: string;
}

/* Initial State */
const initialState: ISortHotelsReducer = {
    needSyncSortWithServer: false,
    sortOrigin: undefined,
};

/* Reducer */
export default createReducer<ISortHotelsReducer, TSortActions>(initialState)
    /* Fill sortInfo by searchInfo from server */
    .handleAction(fillSortInfo, (state, {payload}): ISortHotelsReducer => {
        const {sortInfo} = payload;

        return {
            ...state,
            sortInfo,
            needSyncSortWithServer: false,
        };
    })
    /* Set active sort and start sync sortInfo with server */
    .handleAction(setActiveSort, (state, {payload}): ISortHotelsReducer => {
        const {id, sortOrigin} = payload;
        const availableSortTypeGroups =
            state?.sortInfo?.availableSortTypeGroups || [];

        return {
            ...state,
            sortInfo: {
                availableSortTypeGroups,
                selectedSortId: id,
            },
            sortOrigin,
            needSyncSortWithServer: true,
        };
    })
    /* Set active sort and start sync sortInfo with server */
    .handleAction(resetSortToInitial, (): ISortHotelsReducer => initialState);
