import {createReducer} from 'typesafe-actions';
import cuid from 'cuid';

import {TSuggestItems} from 'types/hotels/common/ISearchSuggest';

const initialState = {
    isLoading: false,
    timeMarker: null,
    items: [],
    requestIndex: 0,
    sessionId: '',
};

export interface ISearchSuggest {
    isLoading: boolean;
    timeMarker: number | null;
    items: TSuggestItems;
    requestIndex: number;
    sessionId: string;
}

import {
    SearchSuggestActionsTypes,
    fetchSearchSuggestActions,
    resetSessionInfoSuggestAction,
    fetchAndSelectSearchSuggestAction,
} from './actions';

/* Reducer */
export default createReducer<ISearchSuggest, SearchSuggestActionsTypes>(
    initialState,
)
    .handleAction(
        [fetchSearchSuggestActions.request, fetchAndSelectSearchSuggestAction],
        state => {
            const {requestIndex, sessionId} = state;

            return {
                ...state,
                requestIndex: requestIndex + 1,
                sessionId: sessionId ? sessionId : cuid(),
                isLoading: true,
            };
        },
    )
    .handleAction(
        fetchSearchSuggestActions.success,
        (state, {payload}): ISearchSuggest => {
            const {timeMarker: lastTimeMarker} = state;
            const {timeMarker, items} = payload;

            if (lastTimeMarker === null || timeMarker >= lastTimeMarker) {
                return {
                    ...state,
                    items,
                    timeMarker,
                    isLoading: false,
                };
            }

            return state;
        },
    )
    .handleAction(
        resetSessionInfoSuggestAction,
        (state): ISearchSuggest => ({
            ...state,
            requestIndex: 0,
            sessionId: cuid(),
        }),
    )
    .handleAction(
        fetchSearchSuggestActions.failure,
        (): ISearchSuggest => initialState,
    );
