import {GeoIdType} from 'types/hotels/hotel/IGeoRegion';
import {IHotelIdentifier} from 'types/hotels/hotel/IHotel';
import {TSuggestItems} from 'types/hotels/common/ISearchSuggest';
import {TGeoRegionSlug} from 'types/hotels/geoRegion/IGeoRegionInfo';
import {EGeoLocationStatus} from 'types/common/browserGeolocation';

export interface IFetchSearchSuggestActionPayload {
    fieldType: string;
    fetchParams: {
        inputValue: string;
    };
}

export interface ILogSearchSuggestPayload {
    selectedId: string;
    isManualClick: boolean;
    // TODO: удалить после выкатки фронт+бек (переименовано в isManualClick)
    isUserInput: boolean;
    isTrustedUser: boolean;
}

export interface IFetchSearchSuggestSuccessActionPayload {
    timeMarker: number;
    items: TSuggestItems;
}

export interface IFetchAndSelectSuggestActionPayload extends IHotelIdentifier {
    geoId?: GeoIdType;
    regionSlug?: TGeoRegionSlug;
    userCoordinates?: string;
    geoLocationStatus?: EGeoLocationStatus;
    /** true - если мы заполняем саджест в форме специальным саггестом "отели рядом"  */
    canSelectNearbyHotel?: boolean;
}
