import {Request} from '@yandex-data-ui/core/lib/types';

import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {isAuthUser} from 'utilities/userInfo/isAuthUser';

import {orders as ordersProvider} from 'serviceProvider/orders/orders';

import {fetchPromocodeAvailability} from './actions';

export const fetchWelcomePromocode =
    ({req}: {req?: Request}): CustomThunkAction<void> =>
    async (dispatch, getState): Promise<void> => {
        const userInfo = getState().common.userInfo;
        const isAuth = isAuthUser(userInfo);

        if (!isAuth) {
            dispatch(fetchPromocodeAvailability.success(true));

            return;
        }

        dispatch(fetchPromocodeAvailability.request());

        try {
            const result = await ordersProvider
                .provider(req?.container)
                .getUserPromoAttributes();

            dispatch(
                fetchPromocodeAvailability.success(
                    result.first_order_promo_code_eligible,
                ),
            );
        } catch (e) {
            dispatch(fetchPromocodeAvailability.failure());
        }
    };
