import {ActionType, createReducer} from 'typesafe-actions';

import EAsyncStatus from 'types/common/EAsyncStatus';
import {IHotelsExtranetAddHotelResponse} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetAddHotelResponse';

import {addHotelActions, resetAddedHotel} from './actions';

export interface IHotelsExtranetAddHotelReducer {
    status?: EAsyncStatus;
    response?: IHotelsExtranetAddHotelResponse;
}

const INITIAL_STATE = {};

export const addHotelReducer = createReducer<
    IHotelsExtranetAddHotelReducer,
    ActionType<typeof addHotelActions> | ActionType<typeof resetAddedHotel>
>(INITIAL_STATE)
    .handleAction(
        addHotelActions.request,
        (): IHotelsExtranetAddHotelReducer => ({
            status: EAsyncStatus.LOADING,
        }),
    )
    .handleAction(
        addHotelActions.success,
        (state, {payload}): IHotelsExtranetAddHotelReducer => ({
            status: EAsyncStatus.SUCCESS,
            response: payload,
        }),
    )
    .handleAction(
        addHotelActions.failure,
        (): IHotelsExtranetAddHotelReducer => ({
            status: EAsyncStatus.ERROR,
        }),
    )
    .handleAction(resetAddedHotel, () => INITIAL_STATE);
