import {IHotelsExtranetAddHotelRequest} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetAddHotelRequest';

import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {browserHotelsExtranetProvider} from 'serviceProvider/hotelsExtranet/browserHotelsExtranetProvider';

import {addHotelActions} from './actions';

export function addHotel(
    request: IHotelsExtranetAddHotelRequest,
): CustomThunkAction<Promise<void>> {
    return async (dispatch): Promise<void> => {
        try {
            dispatch(addHotelActions.request(request));

            const data = await browserHotelsExtranetProvider.addHotel(request);

            dispatch(addHotelActions.success(data));
        } catch (error) {
            dispatch(addHotelActions.failure());
        }
    };
}
