import {ActionType, createReducer} from 'typesafe-actions';

import EAsyncStatus from 'types/common/EAsyncStatus';
import {IHotelsExtranetApproveHotelResponse} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetApproveHotelResponse';

import {approveHotelActions} from './actions';

export interface IHotelsExtranetApproveHotelReducer {
    status?: EAsyncStatus;
    response?: IHotelsExtranetApproveHotelResponse;
}

const INITIAL_STATE = {};

export const approveHotelReducer = createReducer<
    IHotelsExtranetApproveHotelReducer,
    ActionType<typeof approveHotelActions>
>(INITIAL_STATE)
    .handleAction(
        approveHotelActions.request,
        (): IHotelsExtranetApproveHotelReducer => ({
            status: EAsyncStatus.LOADING,
        }),
    )
    .handleAction(
        approveHotelActions.success,
        (state, {payload}): IHotelsExtranetApproveHotelReducer => ({
            status: EAsyncStatus.SUCCESS,
            response: payload,
        }),
    )
    .handleAction(
        approveHotelActions.failure,
        (): IHotelsExtranetApproveHotelReducer => ({
            status: EAsyncStatus.ERROR,
        }),
    );
