import {IHotelsExtranetApproveHotelRequest} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetApproveHotelRequest';

import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {browserHotelsExtranetProvider} from 'serviceProvider/hotelsExtranet/browserHotelsExtranetProvider';

import {approveHotelActions} from './actions';

export function approveHotel(
    request: IHotelsExtranetApproveHotelRequest,
): CustomThunkAction<Promise<void>> {
    return async (dispatch): Promise<void> => {
        try {
            dispatch(approveHotelActions.request(request));

            const data = await browserHotelsExtranetProvider.approveHotel(
                request,
            );

            dispatch(approveHotelActions.success(data));
        } catch (error) {
            dispatch(approveHotelActions.failure());
        }
    };
}
