import {createAsyncAction, createAction} from 'typesafe-actions';

import {
    IExtranetHotel,
    IHotelsListResponse,
} from 'server/api/HotelsExtranetApi/types/IHotelsListResponse';

interface IHotelsListSuccess {
    hotelFromUrl?: IExtranetHotel;
    response: IHotelsListResponse;
}

export const hotelsListActions = createAsyncAction(
    'hotelsExtranet/hotelsList/request',
    'hotelsExtranet/hotelsList/success',
    'hotelsExtranet/hotelsList/failed',
)<void, IHotelsListSuccess, void>();

export const selectHotel = createAction(
    'hotelsExtranet/hotelsList/selectHotel',
)<IExtranetHotel>();
