import {ActionType, createReducer} from 'typesafe-actions';

import EAsyncStatus from 'types/common/EAsyncStatus';
import {
    IExtranetHotel,
    IHotelsListResponse,
} from 'server/api/HotelsExtranetApi/types/IHotelsListResponse';

import {hotelsListActions, selectHotel} from './actions';

export interface IHotelsExtranetHotelsListReducer {
    status?: EAsyncStatus;
    response?: IHotelsListResponse;
    currentHotel?: IExtranetHotel;
}

const INITIAL_STATE = {};

export const hotelsListReducer = createReducer<
    IHotelsExtranetHotelsListReducer,
    ActionType<typeof hotelsListActions> | ActionType<typeof selectHotel>
>(INITIAL_STATE)
    .handleAction(
        hotelsListActions.request,
        (): IHotelsExtranetHotelsListReducer => ({
            status: EAsyncStatus.LOADING,
        }),
    )
    .handleAction(
        hotelsListActions.success,
        (
            state,
            {payload: {response, hotelFromUrl}},
        ): IHotelsExtranetHotelsListReducer => ({
            status: EAsyncStatus.SUCCESS,
            response,
            currentHotel:
                response.hotels.find(
                    h =>
                        h.hotelCode === hotelFromUrl?.hotelCode &&
                        h.partnerId === hotelFromUrl?.partnerId,
                ) || hotelFromUrl,
        }),
    )
    .handleAction(
        hotelsListActions.failure,
        (): IHotelsExtranetHotelsListReducer => ({
            status: EAsyncStatus.ERROR,
        }),
    )
    .handleAction(
        selectHotel,
        (state, {payload}): IHotelsExtranetHotelsListReducer => ({
            ...state,
            currentHotel: payload,
        }),
    );
