import {IExtranetHotel} from 'server/api/HotelsExtranetApi/types/IHotelsListResponse';

import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {params} from 'utilities/metrika';

import {browserHotelsExtranetProvider} from 'serviceProvider/hotelsExtranet/browserHotelsExtranetProvider';

import {hotelsListActions, selectHotel} from './actions';

export function setSelectedHotel(
    hotel: IExtranetHotel,
): CustomThunkAction<void> {
    return (dispatch): void => {
        dispatch(selectHotel(hotel));
        params({
            hotelsExtranet: {
                hotelSlug: hotel.slug,
                hotelPermalink: hotel.permalink,
            },
        });
    };
}

export function getHotelsList(
    hotelFromUrl?: IExtranetHotel,
): CustomThunkAction<Promise<void>> {
    return async (dispatch): Promise<void> => {
        try {
            dispatch(hotelsListActions.request());

            const response = await browserHotelsExtranetProvider.getHotels();

            dispatch(hotelsListActions.success({hotelFromUrl, response}));
        } catch (error) {
            dispatch(hotelsListActions.failure());
        }
    };
}
