import {ActionType, createReducer} from 'typesafe-actions';

import EAsyncStatus from 'types/common/EAsyncStatus';
import {IHotelsExtranetOrdersResponse} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetOrdersResponse';
import {IHotelsExtranetOrdersRequest} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetOrdersRequest';

import {getOrdersActions, resetOrders} from './actions';

export interface IHotelsExtranetOrdersReducer {
    status?: EAsyncStatus;
    response?: IHotelsExtranetOrdersResponse;
    request?: IHotelsExtranetOrdersRequest;
}

const INITIAL_STATE = {};

export const ordersReducer = createReducer<
    IHotelsExtranetOrdersReducer,
    ActionType<typeof getOrdersActions | typeof resetOrders>
>(INITIAL_STATE)
    .handleAction(
        getOrdersActions.request,
        (state, {payload}): IHotelsExtranetOrdersReducer => ({
            ...state,
            status: EAsyncStatus.LOADING,
            request: payload,
        }),
    )
    .handleAction(
        getOrdersActions.success,
        (state, {payload}): IHotelsExtranetOrdersReducer => ({
            ...state,
            status: EAsyncStatus.SUCCESS,
            response: payload,
        }),
    )
    .handleAction(
        getOrdersActions.failure,
        (state): IHotelsExtranetOrdersReducer => ({
            ...state,
            status: EAsyncStatus.ERROR,
            response: undefined,
        }),
    )
    .handleAction(
        resetOrders,
        (): IHotelsExtranetOrdersReducer => INITIAL_STATE,
    );
