import {
    IHotelsExtranetOrdersFilters,
    IHotelsExtranetOrdersRequest,
    TSortFieldName,
} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetOrdersRequest';
import {ISortBy} from 'server/api/HotelsExtranetApi/types/ISortBy';

import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {ordersSelector} from 'selectors/hotelsExtranet/ordersSelector';

import {getPageCount} from 'projects/hotelsExtranet/utilities/getPageCount';

import {browserHotelsExtranetProvider} from 'serviceProvider/hotelsExtranet/browserHotelsExtranetProvider';

import {getOrdersActions} from './actions';

export function setPage(page: number): CustomThunkAction<void> {
    return (dispatch, getState): void => {
        const state = getState();
        const {request} = ordersSelector(state);

        if (request) {
            dispatch(
                fetchOrders({
                    ...request,
                    page: {
                        ...request.page,
                        num: page,
                    },
                }),
            );
        }
    };
}

export function setPageSize(pageSize: number): CustomThunkAction<void> {
    return (dispatch, getState): void => {
        const state = getState();
        const {request, response} = ordersSelector(state);

        if (request && response) {
            const {page} = request;
            const pageCount = getPageCount(response.totalRecords, pageSize) - 1;
            const num = page.num > pageCount ? pageCount : page.num;

            dispatch(
                fetchOrders({
                    ...request,
                    page: {
                        num,
                        limit: pageSize,
                    },
                }),
            );
        }
    };
}

export function setSortField(
    sortBy?: ISortBy<TSortFieldName>,
): CustomThunkAction<void> {
    return (dispatch, getState): void => {
        const state = getState();
        const {request} = ordersSelector(state);

        if (request) {
            dispatch(
                fetchOrders({
                    ...request,
                    sortFields: sortBy ? [sortBy] : undefined,
                }),
            );
        }
    };
}

export function setFilters(
    filters: IHotelsExtranetOrdersFilters,
): CustomThunkAction<void> {
    return (dispatch, getState): void => {
        const state = getState();
        const {request} = ordersSelector(state);

        if (request) {
            dispatch(fetchOrders({...request, ...filters}));
        }
    };
}

export function fetchOrders(
    request: IHotelsExtranetOrdersRequest,
): CustomThunkAction<Promise<void>> {
    return async (dispatch): Promise<void> => {
        try {
            dispatch(getOrdersActions.request(request));

            const data = await browserHotelsExtranetProvider.getOrders(request);

            dispatch(getOrdersActions.success(data));
        } catch (error) {
            dispatch(getOrdersActions.failure());
        }
    };
}
