import {ActionType, createReducer} from 'typesafe-actions';

import EAsyncStatus from 'types/common/EAsyncStatus';
import {IHotelsExtranetPaymentsResponse} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetPaymentsResponse';
import {IHotelsExtranetPaymentsRequest} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetPaymentsRequest';

import {getPaymentsActions, resetPayments} from './actions';

export interface IHotelsExtranetPaymentsReducer {
    status?: EAsyncStatus;
    response?: IHotelsExtranetPaymentsResponse;
    request?: IHotelsExtranetPaymentsRequest;
}

const INITIAL_STATE = {};

export const paymentsReducer = createReducer<
    IHotelsExtranetPaymentsReducer,
    ActionType<typeof getPaymentsActions | typeof resetPayments>
>(INITIAL_STATE)
    .handleAction(
        getPaymentsActions.request,
        (state, {payload}): IHotelsExtranetPaymentsReducer => ({
            ...state,
            status: EAsyncStatus.LOADING,
            request: payload,
        }),
    )
    .handleAction(
        getPaymentsActions.success,
        (state, {payload}): IHotelsExtranetPaymentsReducer => ({
            ...state,
            status: EAsyncStatus.SUCCESS,
            response: payload,
        }),
    )
    .handleAction(
        getPaymentsActions.failure,
        (state): IHotelsExtranetPaymentsReducer => ({
            ...state,
            status: EAsyncStatus.ERROR,
            response: undefined,
        }),
    )
    .handleAction(
        resetPayments,
        (): IHotelsExtranetPaymentsReducer => INITIAL_STATE,
    );
