import {IHotelsExtranetPaymentsRequest} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetPaymentsRequest';
import {ISortBy} from 'server/api/HotelsExtranetApi/types/ISortBy';
import {IDateFilter} from 'server/api/HotelsExtranetApi/types/IDateFilter';
import {TSortFieldName} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetPaymentsResponse';

import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {paymentsSelector} from 'selectors/hotelsExtranet/paymentsSelector';

import {getPageCount} from 'projects/hotelsExtranet/utilities/getPageCount';

import {DEFAULT_PAGE_SIZE} from 'projects/hotelsExtranet/components/Paginator/Paginator';

import {browserHotelsExtranetProvider} from 'serviceProvider/hotelsExtranet/browserHotelsExtranetProvider';

import {getPaymentsActions} from './actions';

export function setPage(pageNumber: number): CustomThunkAction<void> {
    return (dispatch, getState): void => {
        const state = getState();
        const {request} = paymentsSelector(state);

        if (request) {
            const {page = {limit: DEFAULT_PAGE_SIZE, num: 0}} = request;

            dispatch(
                fetchPayments({
                    ...request,
                    page: {
                        ...page,
                        num: pageNumber,
                    },
                }),
            );
        }
    };
}

export function setPageSize(pageSize: number): CustomThunkAction<void> {
    return (dispatch, getState): void => {
        const state = getState();
        const {request, response} = paymentsSelector(state);

        if (request && response) {
            const {page} = request;
            const pageCount = getPageCount(response.totalRecords, pageSize) - 1;
            const num = page.num > pageCount ? pageCount : page.num;

            dispatch(
                fetchPayments({
                    ...request,
                    page: {
                        num,
                        limit: pageSize,
                    },
                }),
            );
        }
    };
}

export function setSortField(
    sortBy?: ISortBy<TSortFieldName>,
): CustomThunkAction<void> {
    return (dispatch, getState): void => {
        const state = getState();
        const {request} = paymentsSelector(state);

        if (request) {
            dispatch(
                fetchPayments({
                    ...request,
                    sortFields: sortBy ? [sortBy] : undefined,
                }),
            );
        }
    };
}

export function setFilters(eventTime?: IDateFilter): CustomThunkAction<void> {
    return (dispatch, getState): void => {
        const state = getState();
        const {request} = paymentsSelector(state);

        if (request) {
            dispatch(fetchPayments({...request, eventTime}));
        }
    };
}

export function fetchPayments(
    request: IHotelsExtranetPaymentsRequest,
): CustomThunkAction<Promise<void>> {
    return async (dispatch): Promise<void> => {
        try {
            dispatch(getPaymentsActions.request(request));

            const data = await browserHotelsExtranetProvider.getPayments(
                request,
            );

            dispatch(getPaymentsActions.success(data));
        } catch (error) {
            dispatch(getPaymentsActions.failure());
        }
    };
}
