import {ActionType, createReducer} from 'typesafe-actions';

import EAsyncStatus from 'types/common/EAsyncStatus';
import {IHotelsExtranetPaymentDetailsResponse} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetPaymentDetailsResponse';

import {getPaymentsActions} from './actions';

export interface IHotelsExtranetPaymentsDetails {
    status?: EAsyncStatus;
    response?: IHotelsExtranetPaymentDetailsResponse;
}
export interface IHotelsExtranetPaymentsDetailsReducer
    extends Record<string, IHotelsExtranetPaymentsDetails> {}

const INITIAL_STATE = {};

export const paymentsDetailsReducer = createReducer<
    IHotelsExtranetPaymentsDetailsReducer,
    ActionType<typeof getPaymentsActions>
>(INITIAL_STATE)
    .handleAction(
        getPaymentsActions.request,
        (state, {payload}): IHotelsExtranetPaymentsDetailsReducer => ({
            ...state,
            [payload.paymentBatchId]: {
                status: EAsyncStatus.LOADING,
            },
        }),
    )
    .handleAction(
        getPaymentsActions.success,
        (
            state,
            {payload: {request, response}},
        ): IHotelsExtranetPaymentsDetailsReducer => ({
            ...state,
            [request.paymentBatchId]: {
                status: EAsyncStatus.SUCCESS,
                response,
            },
        }),
    )
    .handleAction(
        getPaymentsActions.failure,
        (state, {payload}): IHotelsExtranetPaymentsDetailsReducer => ({
            ...state,
            [payload.paymentBatchId]: {
                status: EAsyncStatus.ERROR,
            },
        }),
    );
