import {IHotelsExtranetPaymentDetailsRequest} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetPaymentDetailsRequest';

import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {browserHotelsExtranetProvider} from 'serviceProvider/hotelsExtranet/browserHotelsExtranetProvider';

import {getPaymentsActions} from './actions';

export function fetchPaymentDetails(
    request: IHotelsExtranetPaymentDetailsRequest,
): CustomThunkAction<Promise<void>> {
    return async (dispatch): Promise<void> => {
        try {
            dispatch(getPaymentsActions.request(request));

            const response =
                await browserHotelsExtranetProvider.getPaymentDetails(request);

            dispatch(getPaymentsActions.success({request, response}));
        } catch (error) {
            dispatch(getPaymentsActions.failure(request));
        }
    };
}
