import {combineReducers} from 'redux';

import {IHotelsExtranetStore} from 'reducers/hotelsExtranet/IHotelsExtranetStore';

import {ordersReducer} from './orders/reducer';
import {paymentsReducer} from './payments/reducer';
import {paymentsDetailsReducer} from './paymentsDetails/reducer';
import {addHotelReducer} from './addHotel/reducer';
import {approveHotelReducer} from './approveHotel/reducer';
import {hotelsListReducer} from './hotelsList/reducer';
import {upcomingArrivalsReducer} from './upcomingArrivals/reducer';

const hotelsExtranetRootReducer = combineReducers<IHotelsExtranetStore>({
    orders: ordersReducer,
    payments: paymentsReducer,
    paymentsDetails: paymentsDetailsReducer,
    addHotel: addHotelReducer,
    approveHotel: approveHotelReducer,
    hotelsList: hotelsListReducer,
    upcomingArrivals: upcomingArrivalsReducer,
});

export default hotelsExtranetRootReducer;
