import {ActionType, createReducer} from 'typesafe-actions';

import EAsyncStatus from 'types/common/EAsyncStatus';
import {IHotelsExtranetOrdersResponse} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetOrdersResponse';
import {IHotelsExtranetOrdersRequest} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetOrdersRequest';

import {getUpcomingArrivalsActions, resetUpcomingArrivals} from './actions';

export interface IHotelsExtranetUpcomingArrivalsReducer {
    status?: EAsyncStatus;
    response?: IHotelsExtranetOrdersResponse;
    request?: IHotelsExtranetOrdersRequest;
}

const INITIAL_STATE = {};

export const upcomingArrivalsReducer = createReducer<
    IHotelsExtranetUpcomingArrivalsReducer,
    ActionType<typeof getUpcomingArrivalsActions | typeof resetUpcomingArrivals>
>(INITIAL_STATE)
    .handleAction(
        getUpcomingArrivalsActions.request,
        (state, {payload}): IHotelsExtranetUpcomingArrivalsReducer => ({
            ...state,
            status: EAsyncStatus.LOADING,
            request: payload,
        }),
    )
    .handleAction(
        getUpcomingArrivalsActions.success,
        (state, {payload}): IHotelsExtranetUpcomingArrivalsReducer => ({
            ...state,
            status: EAsyncStatus.SUCCESS,
            response: payload,
        }),
    )
    .handleAction(
        getUpcomingArrivalsActions.failure,
        (state): IHotelsExtranetUpcomingArrivalsReducer => ({
            ...state,
            status: EAsyncStatus.ERROR,
            response: undefined,
        }),
    )
    .handleAction(
        resetUpcomingArrivals,
        (): IHotelsExtranetUpcomingArrivalsReducer => INITIAL_STATE,
    );
