import {IHotelsExtranetOrdersRequest} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetOrdersRequest';

import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {browserHotelsExtranetProvider} from 'serviceProvider/hotelsExtranet/browserHotelsExtranetProvider';

import {getUpcomingArrivalsActions} from './actions';

export function fetchUpcomingArrivals(
    request: IHotelsExtranetOrdersRequest,
): CustomThunkAction<Promise<void>> {
    return async (dispatch): Promise<void> => {
        try {
            dispatch(getUpcomingArrivalsActions.request(request));

            const data = await browserHotelsExtranetProvider.getOrders(request);

            dispatch(getUpcomingArrivalsActions.success(data));
        } catch (error) {
            dispatch(getUpcomingArrivalsActions.failure());
        }
    };
}
