import {createAsyncAction} from 'typesafe-actions';

import {
    IGetContextPageArticle,
    IGetContextPageTag,
} from 'server/api/TemplatorApi/types/IGetContextPageResponse';
import {IJournalRootPage, IJournalTagPage} from 'reducers/journal/types';

export const getArticlePageActions = createAsyncAction(
    'journal/getArticlePage/start',
    'journal/getArticlePage/success',
    'journal/getArticlePage/failed',
)<string, Nullable<IGetContextPageArticle>, undefined>();

export const getRootPageActions = createAsyncAction(
    'journal/getRootPage/start',
    'journal/getRootPage/success',
    'journal/getRootPage/failed',
)<undefined, Nullable<IJournalRootPage>, undefined>();

export const getTagPageActions = createAsyncAction(
    'journal/getTagPage/start',
    'journal/getTagPage/success',
    'journal/getTagPage/failed',
)<undefined, Nullable<IJournalTagPage>, undefined>();

export const getTagsListActions = createAsyncAction(
    'journal/getTagsList/start',
    'journal/getTagsList/success',
    'journal/getTagsList/failed',
)<undefined, IGetContextPageTag[], undefined>();
