import {ActionType, createReducer} from 'typesafe-actions';

import {
    IGetContextPageArticle,
    IGetContextPageTag,
} from 'server/api/TemplatorApi/types/IGetContextPageResponse';
import {IAsyncDataState} from 'types/IAsyncDataState';
import {IJournalRootPage, IJournalTagPage} from 'reducers/journal/types';

import * as actions from 'reducers/journal/actions';

import {
    getAsyncDataErrorState,
    getAsyncDataFetchingState,
    getAsyncDataInitialState,
    getAsyncDataSuccessState,
} from 'utilities/asyncDataState';

interface IJournalPages {
    root: IAsyncDataState<Nullable<IJournalRootPage>>;
    tag: IAsyncDataState<Nullable<IJournalTagPage>>;
    article: IAsyncDataState<Nullable<IGetContextPageArticle>>;
}

export interface IJournalState {
    pages: IJournalPages;
    tags: IAsyncDataState<IGetContextPageTag[]>;
}

const initialState: IJournalState = {
    pages: {
        root: getAsyncDataInitialState<Nullable<IJournalRootPage>>(null),
        tag: getAsyncDataInitialState<Nullable<IJournalTagPage>>(null),
        article:
            getAsyncDataInitialState<Nullable<IGetContextPageArticle>>(null),
    },
    tags: getAsyncDataInitialState<IGetContextPageTag[]>([]),
};

export default createReducer<IJournalState, ActionType<typeof actions>>(
    initialState,
)
    // handle root page
    .handleAction(actions.getRootPageActions.request, state => ({
        ...state,
        pages: {
            ...state.pages,
            root: getAsyncDataFetchingState(null),
        },
    }))
    .handleAction(actions.getRootPageActions.success, (state, {payload}) => ({
        ...state,
        pages: {
            ...state.pages,
            root: getAsyncDataSuccessState(payload),
        },
    }))
    .handleAction(actions.getRootPageActions.failure, state => ({
        ...state,
        pages: {
            ...state.pages,
            root: getAsyncDataErrorState(null),
        },
    }))

    // handle tag page
    .handleAction(actions.getTagPageActions.request, state => ({
        ...state,
        pages: {
            ...state.pages,
            tag: getAsyncDataFetchingState(null),
        },
    }))
    .handleAction(actions.getTagPageActions.success, (state, {payload}) => ({
        ...state,
        pages: {
            ...state.pages,
            tag: getAsyncDataSuccessState(payload),
        },
    }))
    .handleAction(actions.getTagPageActions.failure, state => ({
        ...state,
        pages: {
            ...state.pages,
            tag: getAsyncDataErrorState(null),
        },
    }))

    // handle article page
    .handleAction(actions.getArticlePageActions.request, state => ({
        ...state,
        pages: {
            ...state.pages,
            article: getAsyncDataFetchingState(null),
        },
    }))
    .handleAction(
        actions.getArticlePageActions.success,
        (state, {payload}) => ({
            ...state,
            pages: {
                ...state.pages,
                article: getAsyncDataSuccessState(payload),
            },
        }),
    )
    .handleAction(actions.getArticlePageActions.failure, state => ({
        ...state,
        pages: {
            ...state.pages,
            tag: getAsyncDataErrorState(null),
        },
    }))

    // handle tags list
    .handleAction(actions.getTagsListActions.request, state => ({
        ...state,
        tags: getAsyncDataFetchingState(state.tags.data),
    }))
    .handleAction(actions.getTagsListActions.success, (state, {payload}) => ({
        ...state,
        tags: getAsyncDataSuccessState(payload),
    }))
    .handleAction(actions.getTagsListActions.failure, state => ({
        ...state,
        tags: getAsyncDataErrorState([]),
    }));
