import {IBaseJournalFetchParams} from 'reducers/journal/types';
import {EContentPageMode} from 'projects/journal/types/EContentPageMode';

import {fetchTags} from 'reducers/journal/thunk/fetchTags';
import {getArticlePageActions} from 'reducers/journal/actions';
import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {journalDeviceSelector} from 'selectors/journal/journalDeviceSelector';
import journalTagsListSelector from 'selectors/journal/journalTagsListSelector';

import {templatorService} from 'serviceProvider';

interface IFetchArticleRequestParams extends IBaseJournalFetchParams {
    semanticId: string;
}

export const fetchArticle = ({
    semanticId,
    isPreview,
    branch,
    req,
}: IFetchArticleRequestParams): CustomThunkAction<void> => {
    return async (dispatch, getState): Promise<void> => {
        try {
            const state = getState();
            const device = journalDeviceSelector(state);
            const tags = journalTagsListSelector(state);

            dispatch(getArticlePageActions.request(semanticId));
            dispatch(
                getArticlePageActions.success(
                    await templatorService.provider(req?.container).getArticle({
                        device,
                        ds: branch,
                        semantic_id: semanticId,
                        templator_content: isPreview
                            ? EContentPageMode.PREVIEW
                            : undefined,
                    }),
                ),
            );

            if (!tags.isFetched) {
                await dispatch(fetchTags({req, branch, isPreview}));
            }
        } catch (error) {
            dispatch(getArticlePageActions.failure());
        }
    };
};
