import {IBaseJournalFetchParams} from 'reducers/journal/types';
import {EContentPageMode} from 'projects/journal/types/EContentPageMode';

import {fetchTags} from 'reducers/journal/thunk/fetchTags';
import {getRootPageActions} from 'reducers/journal/actions';
import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {journalDeviceSelector} from 'selectors/journal/journalDeviceSelector';

import {templatorService} from 'serviceProvider';

interface IFetchRootPageRequestParams extends IBaseJournalFetchParams {
    semanticId: string;
}

export const fetchRootPage = ({
    req,
    branch,
    isPreview,
    semanticId,
}: IFetchRootPageRequestParams): CustomThunkAction<void> => {
    return async (dispatch, getState): Promise<void> => {
        try {
            dispatch(getRootPageActions.request());

            const device = journalDeviceSelector(getState());
            const serviceProvider = templatorService.provider(req?.container);
            const templatorContent = isPreview
                ? EContentPageMode.PREVIEW
                : undefined;

            const fetchingMeta = serviceProvider.getRootMeta({
                device,
                ds: branch,
                semantic_id: semanticId,
                templator_content: templatorContent,
            });
            const fetchingArticles = serviceProvider.getArticles({
                device,
                ds: branch,
                templator_content: templatorContent,
            });
            const fetchingTags = dispatch(fetchTags({req, branch, isPreview}));

            const [meta, articles] = await Promise.all([
                fetchingMeta,
                fetchingArticles,
                fetchingTags,
            ]);

            dispatch(
                getRootPageActions.success({
                    meta,
                    articles,
                }),
            );
        } catch (error) {
            dispatch(getRootPageActions.failure());
        }
    };
};
