import {IBaseJournalFetchParams} from 'reducers/journal/types';
import {EContentPageMode} from 'projects/journal/types/EContentPageMode';

import {getTagPageActions} from 'reducers/journal/actions';
import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {journalDeviceSelector} from 'selectors/journal/journalDeviceSelector';

import {templatorService} from 'serviceProvider';

export interface IFetchTagParams extends IBaseJournalFetchParams {
    tagSlug: string;
}

export const fetchTagPage = ({
    req,
    tagSlug,
    branch,
    isPreview,
}: IFetchTagParams): CustomThunkAction<void> => {
    return async (dispatch, getState): Promise<void> => {
        try {
            dispatch(getTagPageActions.request());

            const device = journalDeviceSelector(getState());
            const serviceProvider = templatorService.provider(req?.container);
            const templatorContent = isPreview
                ? EContentPageMode.PREVIEW
                : undefined;

            const meta = await serviceProvider.getTagInfo({
                device,
                tagSlug,
                ds: branch,
                templator_content: templatorContent,
            });

            const articles = await serviceProvider.getArticles({
                device,
                ds: branch,
                tag: meta.tagId,
                templator_content: templatorContent,
            });

            dispatch(
                getTagPageActions.success({
                    meta,
                    articles,
                }),
            );
        } catch (error) {
            dispatch(getTagPageActions.failure());
        }
    };
};
